/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.actions;

import com.aptana.ide.syncing.ui.actions.DownloadAction;
import com.aptana.ide.syncing.ui.actions.UploadAction;
import com.aptana.ui.util.UIUtils;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;

public final class Sync {
    public static void uploadCurrentEditor() {
        IEditorPart editor = UIUtils.getActiveEditor();
        if (editor != null) {
            Sync.uploadEditor(editor.getEditorInput());
        }
    }

    public static void uploadEditor(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            Sync.upload((IAdaptable)((IFileEditorInput)input).getFile());
        } else if (input instanceof IPathEditorInput) {
            IPath path = ((IPathEditorInput)input).getPath();
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFileForLocation(path);
            if (file != null) {
                Sync.upload((IAdaptable)file);
            } else {
                Sync.upload(path);
            }
        } else if (input instanceof IURIEditorInput) {
            IURIEditorInput editorInput = (IURIEditorInput)input;
            try {
                Sync.upload((IAdaptable)EFS.getStore((URI)editorInput.getURI()));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private static void upload(IStructuredSelection selection) {
        UploadAction action = new UploadAction();
        action.setActivePart(null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
        action.setSelection((ISelection)selection);
        action.run(null);
    }

    private static void upload(IAdaptable file) {
        Sync.upload((IStructuredSelection)new StructuredSelection((Object)file));
    }

    private static void upload(IPath path) {
        try {
            Sync.upload((IAdaptable)EFS.getStore((URI)URIUtil.toURI((IPath)path)));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void downloadCurrentEditor() {
        IEditorPart editor = UIUtils.getActiveEditor();
        if (editor == null) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            Sync.download((IAdaptable)((IFileEditorInput)input).getFile());
        } else if (input instanceof IPathEditorInput) {
            Sync.download(((IPathEditorInput)input).getPath());
        } else if (input instanceof IURIEditorInput) {
            IURIEditorInput editorInput = (IURIEditorInput)input;
            try {
                Sync.download((IAdaptable)EFS.getStore((URI)editorInput.getURI()));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private static void download(IStructuredSelection selection) {
        DownloadAction action = new DownloadAction();
        action.setActivePart(null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
        action.setSelection((ISelection)selection);
        action.run(null);
    }

    private static void download(IAdaptable file) {
        Sync.download((IStructuredSelection)new StructuredSelection((Object)file));
    }

    private static void download(IPath path) {
        try {
            Sync.download((IAdaptable)EFS.getStore((URI)URIUtil.toURI((IPath)path)));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

